var animationFPS = 65;
var animationDuration;
var stduration = Math.round(1000*(1/animationFPS));
var movementPX = false;
var surveyHeight;
var surveyWidth;
var surveyObj;

function checkFrequency()
{
	return (!isNaN(Freq)) && (Freq > 0) && (Math.floor(Math.random() * Freq) == 0);
}

// mode used to indicate the calling context.
// mode = 0: This function is called from a none-delayed trigger.
// Such triggers will only check triggerInit(0) once, and if passed, the trigger will be fired,
// otherwise the site survey will be activated.
// mode = 1: This function is called from a delayed trigger.
// Such triggers will call triggerInit(mode) twice, once triggerInit(1), once triggerInit(2).
// triggerInit(1) is called immediately when the page body is loaded to check 
// if the user will be eligible for the trigger Delay milliseconds latter, if not, activate site survey.
// otherwise call setTimeOut(..., Delay), and after Delay milliseconds, the triggerInit(2) will be called
// to see if fms survey can be presented at that moment, if yes, present it, otherwise, do nothing.
function triggerInit(mode)
{
	if (isDomainTracking())
	{
		return false;
	}
	var MiliDay = 86400000;
	var maturity = 1;
	var curDate = new Date();
	var visits = fetchcookieval(CookieDef);
	var parts = visits.split('_');

	if(null == visits || parts.length != 3 || isNaN(parts[0]))
	{
		setcookieval(CookieDef, '1_0_0');
		return false;
	}
	else
	{
		var origDate = parseInt(parts[1]);
		visits = parseInt(parts[0]);
		if
		(
			(!(mode == 0 || mode == 1) || checkFrequency()) && 
			(visits >= maturity) && fmsSurveyExpired(Exp)
		)
		{
			if(mode == 0 || mode == 2)
				setcookieval(CookieDef, visits+1 + '_' + curDate.getTime()/MiliDay + '_' + Exp);
			return true;
		}
		else
		{
			if(mode == 0 || mode == 2)
				setcookieval(CookieDef, visits+1 + '_' + parts[1] + '_' + parts[2]);
			return false;
		}
	}
}

function fireTrigger(SurveyURL)
{
	var sSiteID = '', sSiteRegionID = '', sReferringURL = '', P0 = '', P1 = '', P2 = '', P3 = '', P4 = '', P5 = '', P6 = '', P7 = '', P8 = '', P9 = '';

	var fta = fireTrigger.arguments;
	var l = fta.length;
	if(l > 1) sSiteID = fta[1];
	if(l > 2) sSiteRegionID = fta[2];
	if(l > 3) sReferringURL = fta[3];
	if(l > 4) P0 = fta[4];
	if(l > 5) P1 = fta[5];
	if(l > 6) P2 = fta[6];
	if(l > 7) P3 = fta[7];
	if(l > 8) P4 = fta[8];
	if(l > 9) P5 = fta[9];
	if(l > 12) P8 = fta[12];
	if(l > 13) P9 = fta[13];

	var fullURL = SurveyURL + '&site=' + sSiteID + '&sd=' + sSiteID + '&SurveyStyle=' + SurveyStyle + '&siteregion=' + sSiteRegionID + '&url=' + sReferringURL + '&p0=' + P0 + '&p1=' + P1 + '&p2=' + P2 + '&p3=' + P3 + '&p4=' + P4 + '&p5=' + P5 + '&p6=' + P6 + '&p7=' + P7 + '&p8=' + P8 + '&p9=' + P9;

	// parameters added in FMS 4.0
	fullURL += '&ct=' + StatsDotNet.contentType;
	fullURL += '&cc=' + StatsDotNet.ContentCulture;
	fullURL += '&cid=' + StatsDotNet.contentId;
	fullURL += '&clcid=' + StatsDotNet.contentLn;
	fullURL += '&sc=' + StatsDotNet.SiteCulture;
	fullURL += '&sbid=' + StatsDotNet.siteBrandId;
	fullURL += '&ssid=' + StatsDotNet.ssId;
	fullURL += '&ssver=' + StatsDotNet.SsVersion;
	fullURL += '&cp=' + OutputEncoder_EncodeUrl(StatsDotNet.ContentProperties);

	if (EmailStyle == 1)
		fullURL = fullURL + '&emailsurveyid=' + EmailSurveyID + '&sessionid=-1';
			
	if (DisplayIntroPage != '1')
		fullURL = fullURL + '&showpage=1';
	if (SurveyStyle == null)
		SurveyStyle = "popup";
	SurveyStyle = SurveyStyle.toLowerCase();
	if (SurveyStyle == "embedded")
	{
		if (embedSurveyPrompt == 'nothing') 
			window.location.href = fullURL;
		else
		{
			if (embedSurveyPrompt != "" && window.screenTop<10000 && window.confirm(embedSurveyPrompt) == true) //unload event
			{
				// we can not do a window.location.href for the redirection because when refreshing the window that redirection won't work
				// Optimally if it is refreshing, we should not do survey. But we have no way to know it is refreshing window, so we keep the behavior same
				document.writeln('<html><body>');
				document.writeln('<form name="the_form" action="' + fullURL + '" method="post"><\/form>');
				document.writeln("<\/body><\/html>");
				document.the_form.submit();
			}
		}
	}
	else
	{
		fullURL = fullURL.toLowerCase().replace("survey.aspx", "surveyinvite.aspx");
		if (DisplayIntroPage == '1')
			fullURL = fullURL + '&showpage=1'; //always add &showpage=1
		if (document.location.href.toLowerCase().indexOf('fr=1') > 0)
			fullURL = fullURL + '&fr=1';
		if (TrEvent == 'onunload')
			fullURL = fullURL + '&onunload=1&trigger=' + TriggerId;
		fireSurvey(fullURL);
	}
}

function fireSurvey(fullURL){
	presentSurvey(fullURL);
}

function surveyDiv(fullURL){
	var sd = document.createElement("div");
	sd.id = "surveyDivBlock";
	sd.className = "surveyDiv";
	sd.style.display = "none";
	var si = document.createElement("iframe");
	si.scrolling = 'no';
	si.frameborder = 0;
	si.width = 600;
	si.src = fullURL;
	sd.appendChild(si);
	return sd;
}
function hI(name, value){
	var inp = document.createElement("input");
	inp.type = "hidden";
	inp.name = name;
	inp.value = value;
	return inp;
}
function declineSurvey(el){
	while(el.className != "surveyDiv") el = el.parentNode;
	el.parentNode.removeChild(el);
}

function closeEnough(int1, int2){
	if(Math.abs(int1-int2) <= movementPX) return true;
	return false;
}

function placeXY(p, x, y){
	eval("var z = parseInt("+p+",10);");
	var cent = x-(y/2);
	if(!closeEnough(z, cent)){
		var dir = (z-cent)/Math.abs(z-cent);
		eval(p+" = "+(z-(movementPX*dir)));
		return true;
	}
	return false;
}

function getScrollX()
{
	var documentElement = document.body ? document.body : document.documentElement;
	return (documentElement && surveyObj.style.position != "fixed") ? documentElement.scrollLeft : 0;
}

function getScrollY()
{
	var documentElement = document.body ? document.body : document.documentElement;
	return (documentElement && surveyObj.style.position != "fixed") ? documentElement.scrollTop : 0;
}

function getWindowCenterX()
{
	return Math.round(fbp(window.innerWidth, document.body.clientWidth) / 2 + getScrollX());
}

function getWindowCenterY()
{
	return Math.round(fbp(window.innerHeight, document.body.clientHeight) / 2 + getScrollY());
}

function animateSurvey(){
	calcFPS();
	var cont = placeXY("surveyObj.style.top", getWindowCenterY(), surveyObj.clientHeight);
	if(placeXY("surveyObj.style.left", getWindowCenterX(), surveyObj.clientWidth)) cont = true;
	if(cont) setTimeout("animateSurvey()", stduration);
}

function getPositionDeltaX()
{
	return Math.abs(getWindowCenterX() - (surveyObj.clientWidth / 2 )- parseInt(surveyObj.style.left,10));
}

function getPositionDeltaY()
{
	return Math.abs(getWindowCenterY() - (surveyObj.clientHeight / 2) - parseInt(surveyObj.style.top,10));
}

function fbp(p1, p2)
{
	if(!p1 || p1 < 1)
	{
		return p2;
	}
	return p1;
}

function calcFPS(){
	if(!animationDuration) animationDuration = 0.5;
	var x = getPositionDeltaX();
	var y = getPositionDeltaY();
	
	if(y > x) x = y;
	
	var frameCount = animationDuration * animationFPS;
	movementPX = Math.ceil(x / frameCount);
}

function placeSurvey()
{
	surveyWidth = fbp(surveyObj.clientWidth, surveyObj.offsetWidth);	
	surveyObj.style.left = Math.round(getWindowCenterX() - (surveyWidth / 2));
	surveyObj.style.top = 0;
	animateSurvey();

	if (window.attachEvent)
	{
		window.attachEvent("onresize", animateSurvey);
		window.attachEvent("onscroll", animateSurvey);
	}
	else if (window.addEventListener)
	{
		window.addEventListener("resize", animateSurvey, false);
		surveyObj.style.position = "fixed";
	}
}

function presentSurvey(fullURL){
	surveyObj = surveyDiv(fullURL);	
	document.body.appendChild(surveyObj);
}